clear;
clc;
//WINDOWS 10 64-BIT OS , Scilab and toolbox versions 6.1.0.

//In this analysis, some common scheduling algorithms like First Come First Serve (FCFS), Shortest Job First (SJF) and Round Robin (RR) Scheduling are studied and reviewed on the basis of their Turn Around Time and Average Turn Around Time


//Functions to be loaded
exec("fcfs_tat_atat.sci"); // fcfs_tat_atat.sci dependency file for FCFS Scheduling
exec("sjf_tat_atat.sci"); // sjf_tat_atat.sci dependency file for SJF Scheduling
exec("rr_tat_atat.sci");  // rr_tat_atat.sci dependency file for RR Scheduling

    num=4; //no of processes P1,P2,P3,P4
    bt=[10 2 8 6]; //Sample burst time
    wt=zeros(1,num); //waiting time
    tat=zeros(1,num); //turn around time

disp("Graphical Analysis with Turn-Around Time & Average Turn-Around Time of CPU using SciLab");
disp("Burst time of the given Process P1=10, P2=2, P3=8, P4=6");

disp('Turn Around Time of each Process in FCFS'); //displaying the Turn Around time in FCFS

fcfs = firstcomefirstserve(num,bt,wt,tat)    // Calling first come first serve function 


disp('Turn Around Time of each Process in SJF'); //displaying the Turn Around time of each Process in SJF
sjf = shortestjobfirst(num,bt,wt,tat)    // Calling shortest job first function


disp('Turn Around Time of each Process in Round Robin'); //displaying the Turn Around Time of each Process in Round Robin

rr= roundrobin(num,bt,wt,tat)            // Calling Round Robin function

/*constructing a rows for graphical representation*/

scf(1);

y = [0,10,20,30,40];

x=[1,2,3,4,5]
avg = [10,26,22;12,2,7;20,16,23;26,8,21;17,13,18.25];

/*Matrix avg is set of values obtained from Turn Around time for each algorithm FCFS, SJF, RR respectively*/

xtitle('Graphical Analysis with Turn-Around Time & Average Turn-Around Time of CPU using SciLab',"Process","Turn Around Time");


bar(x,avg);

legend("FCFS","SJF","RR");
